
import javafx.animation.KeyFrame;
import javafx.animation.Timeline;
import javafx.scene.Scene;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.stage.Stage;
import javafx.scene.control.Button;

var x: Integer = 0;
 
var timeline = Timeline {
    // set INDEFINITE to repeat eternally
    repeatCount: Timeline.INDEFINITE

    keyFrames: [
        KeyFrame {
            time: 0s
            values: x => 0
        },
        KeyFrame {
            time: 2s
            values: x => 710
        }
    ]
};

Stage {
    title: "Simple Animation Sample"
    scene: Scene {
        width: 600
        height: 100
        content: [
            ImageView {
                translateX: bind x
                x: -110
                y: 45
                image: Image {
                    url: "{__DIR__}car.png"
                }
            },
            Button {
                var running = false;
                layoutX: 270
                layoutY: 10
                text: bind if (running) "Stop" else "Start"
                action: function() {
                    if (running) {
                        // pause the animation, if animating
                        timeline.pause();
                        running = false;
                    } else {
                        // resume the animation, if pausing
                        timeline.play();
                        running = true;
                    }
                }
            }
        ]
    }
}